from django.shortcuts import render,redirect
from django.http import HttpResponse
from django.contrib.auth import login,logout,authenticate
from django.contrib.auth.models import User

# Create your views here.


def index(request):
    if request.user.is_authenticated:
        return render(request,'student_portal/index.html',context={'user':request.user})
    else:
        return redirect(user_login)


def user_login(request):

    if request.method == 'POST':
        username = request.POST['txtUsername']
        password = request.POST['txtPassword']
        user = authenticate(username=username, password=password)

        if user is not None:
            login(request,user)

            return render(request, 'student_portal/index.html', {'user': user})

    return render(request,'student_portal/login.html',context={})


def add_user(request):
    if request.POST:
        username = request.POST['txtUsername']
        password = request.POST['txtPassword']
        email = request.POST['txtEmail']
        first_name =request.POST['txtFirstName']
        last_name = request.POST['txtLastName']
        gender =request.POST['cboGender']
        user = User.objects.create_user(username= username, password= password, first_name= first_name, last_name= last_name,is_active =0)
        return redirect(user_login)




    return render(request, 'student_portal/add_user.html', context={'user': request.user})





def user_logout(request):

    logout(request)
    return redirect(user_login)

