from django.db import models

# Create your models here.


class Dept(models.Model):
    name = models.CharField(max_length=50, verbose_name='Dept name', unique=True, blank=False)
    location = models.CharField(max_length=50, verbose_name='Dept location', unique=True, blank=False)
    created_date = models.DateTimeField(auto_now_add=True)
    modified_date = models.DateTimeField(auto_now=True)

    def __str__(self):
        return self.name



class Emp(models.Model):

    STATUS_CHOICES = (
        (1, 'Active'),
        (0, 'Inactive'),

    )
    dept = models.ForeignKey(Dept,on_delete=models.PROTECT,related_name="emp_dept")
    name = models.CharField(max_length=50, verbose_name='Employee name', unique=True, blank=False)
    salary = models.FloatField(verbose_name='Salary')
    email = models.EmailField(max_length=50, verbose_name='Employee email', unique=True, blank=False)
    url = models.URLField(max_length=150, verbose_name='Employee url', unique=True, blank=False)
    bio =models.TextField(max_length=5000,verbose_name='Bio', default="test")
    status = models.IntegerField(choices=STATUS_CHOICES, verbose_name="Status")

    created_date = models.DateTimeField(auto_now_add=True)
    modified_date = models.DateTimeField(auto_now=True)

    class Meta:
        verbose_name = 'University Employee'

    def __str__(self):
        return self.name


class Project(models.Model):
    emp = models.ManyToManyField(Emp,verbose_name='Employee')
    name = models.CharField(max_length=50, verbose_name='Project name')
    s_date = models.DateField(verbose_name='Start date')
    e_date = models.DateField(verbose_name='Finish date')
    created_date = models.DateTimeField(auto_now_add=True)
    modified_date = models.DateTimeField(auto_now=True)

    def __str__(self):
        return self.name




