/******************************************************************
 *  All rights reserved  2005 Vitaly Shelest (Javain Ltd)
 *
 *  File name:              CSmartString.h
 *
 *  Last modification:      20.03.2005
 *
 *  Description:            String Helper class
 *
 *  Authors:                Vitaly Shelest
 *
 *****************************************************************/


#pragma once

#include <comdef.h>

namespace jni_helpers
{
#ifdef __JNIHDLL
	class __declspec(dllexport) CSmartString
#elif __USEDLL
	class __declspec(dllimport) CSmartString
#else
	class CSmartString
#endif
    {
    public:
        // Constructors
        //
        CSmartString() throw();
        CSmartString(const CSmartString& s) throw();
        CSmartString(const char* s) ;
        CSmartString(const wchar_t* s) ;
        CSmartString(BSTR bstr, bool fCopy) ;

        // Destructor
        //
        virtual ~CSmartString() throw();

        // Assignment operators
        //
        CSmartString& operator=(const CSmartString& s) throw();
        CSmartString& operator=(const char* s) ;
        CSmartString& operator=(const wchar_t* s) ;

        // Operators
        //
        CSmartString& operator+=(const CSmartString& s) ;
        CSmartString operator+(const CSmartString& s) const ;

        // Friend operators
        //
        friend CSmartString operator+(const char* s1, const CSmartString& s2) ;
        friend CSmartString operator+(const wchar_t* s1, const CSmartString& s2) ;

        // Extractors
        //
        operator const wchar_t*() const throw();
        operator wchar_t*() const throw();
        operator const char*() const ;
        operator char*() const ;

        // Comparison operators
        //
        bool operator!() const throw();
        bool operator==(const CSmartString& str) const throw();
        bool operator!=(const CSmartString& str) const throw();
        bool operator<(const CSmartString& str) const throw();
        bool operator>(const CSmartString& str) const throw();
        bool operator<=(const CSmartString& str) const throw();
        bool operator>=(const CSmartString& str) const throw();

        // Low-level helper functions
        //
        BSTR copy(bool fCopy = true) const ;
        unsigned int length() const throw();

        // Binary string assign
        //
        void Assign(BSTR s) ;

        // Get the physical BSTR
        //
        //BSTR& GetBSTR() ;
        //BSTR* GetAddress() ;

        // Attach to the internal BSTR w/o copying
        //
        //void Attach(BSTR s) ;

        // Detach the internal BSTR
        //
        //BSTR Detach() throw();
    private:
        _bstr_t& bstrString;
    };
    // Return the concatenation of a const char* with a _bstr_t
    //
    inline CSmartString operator+(const char* s1, const CSmartString& s2) 
    {
        CSmartString b = s1; 
        b += s2;
    
        return b;
    }

    // Return the concatenation of a const char* with a _bstr_t
    //
    inline CSmartString operator+(const wchar_t* s1, const CSmartString& s2) 
    {
        CSmartString b = s1; 
        b += s2;
    
        return b;
    }
};


