/******************************************************************
 *  All rights reserved  2005 Vitaly Shelest (Javain Ltd)
 *
 *  File name:              JVM.h
 *
 *  Last modification:      20.03.2005
 *
 *  Description:            JVM Initialization class
 *
 *  Authors:                Vitaly Shelest
 *
 *****************************************************************/

#pragma once

#pragma warning(disable:4251)
#pragma warning(disable:4786)

#include <jni.h>
#include <comdef.h>
#include <set>
#include <vector>
#include "SmartString.h"

namespace jni_helpers
{
    enum EnumInstalledJRE { NO_JRE=0, SUN_JRE, IBM_JRE };
    
    class NativeMethodData
    {
    public:
        CSmartString className;
        JNINativeMethod* methods;
        int numMethods;
        
        NativeMethodData(const CSmartString& className, JNINativeMethod methods[], int numMethods)
            : className( className ), methods( methods ), numMethods( numMethods )
        {
            this->className = className;
            this->numMethods = numMethods;
            this->methods = new JNINativeMethod[numMethods];
            memcpy( this->methods, methods, numMethods*sizeof( JNINativeMethod ) );
        }
    };
    
#ifdef __JNIHDLL
	class __declspec(dllexport) JVM
#elif __USEDLL
	class __declspec(dllimport) JVM
#else
	class JVM
#endif
    {
    private:
        static CSmartString _strVersion;
        static const CSmartString pathSeparator;
        static const CSmartString regKeySUN;
        static const CSmartString regKeyIBM;

        static JavaVM* javaVM;
        static JNIEnv* jniEnv;
        static CSmartString classPath;
        static std::set<CSmartString> options;
        static std::vector<NativeMethodData*> natives;
    public:
        static EnumInstalledJRE jreTypeLoaded;
        
    public:
        static void load();
        static void load(EnumInstalledJRE, CSmartString = "");
        static void load(const CSmartString& jvmLibraryPath);
        static void load_dbg(CSmartString sock="8888");
        static void load_dbg(EnumInstalledJRE, CSmartString = "", CSmartString sock="8888");
        static void load_dbg(const CSmartString& jvmLibraryPath, CSmartString sock="8888");
        static void unload();
        static void initClassPath(const CSmartString& classPath = CSmartString(""));
        static void clearClassPath();
        static void addOption(const CSmartString value);
        static void clearOptions();
        static jint attachCurrentThread();
        static jint detachCurrentThread();
		static const jint version();
        static void registerNatives(const CSmartString& className, JNINativeMethod nativeMethods[], int numMethods);
        
    };
};
