/******************************************************************
 *  All rights reserved  2005 Vitaly Shelest (Javain Ltd)
 *
 *  File name:              JTypeDef.h
 *
 *  Last modification:      20.03.2005
 *
 *  Description:            Java Reference Wrapper class
 *
 *  Authors:                Vitaly Shelest
 *
 *****************************************************************/

#pragma once
#include <jni.h>
//#include "JNIEnvHelper.h"
#include "ArrayIndexOutOfBoundsException.h"
#include "OutOfMemoryException.h"


// Internal jobject holder
//

class JData_t
{
    mutable jobject Obj;
    unsigned long m_RefCount;
    std::string objectClassName;

    friend class JObject_t;
private:
    // Constructors
    //
    JData_t(const jobject o):Obj(0),m_RefCount(0)
    {
        if(o)
        {
            Obj = jni_helpers::JNIEnvHelper::NewGlobalRef(o);
            jni_helpers::JNIEnvHelper::exceptionCheck();
            m_RefCount = 1;
        }
    }

    // Extractors
    //
    operator const jobject() const
    {
        return Obj;
    }
//private:
    // Never allow default construction
    //
    JData_t();

    // Never allow copy
    //
    JData_t(const JData_t&);

    // Prevent deletes from outside. Release() must be used.
    //
    virtual ~JData_t()
    {
        if(Obj)
        {
            jni_helpers::JNIEnvHelper::DeleteGlobalRef(Obj);
			if(jni_helpers::JNIEnvHelper::ExceptionOccurred())
				jni_helpers::JNIEnvHelper::ExceptionClear();
        }
    }

    // Reference counting routines
    //
    unsigned long AddRef()
    {
        InterlockedIncrement(reinterpret_cast<long*>(&m_RefCount));
        return m_RefCount;
    }

    unsigned long Release()
    {
        if (InterlockedDecrement(reinterpret_cast<long*>(&m_RefCount)) == 0) 
        {
            delete this;
            return 0;
        }
        return m_RefCount;
    }
};

// Java Object class, which holds JData_t
// object. It is the base class for all
// java class proxies
//

#ifdef __JNIHDLL
class __declspec(dllexport) JObject_t
#elif __USEDLL
class __declspec(dllimport) JObject_t
#else
class JObject_t
#endif
{
    mutable JData_t* data;
protected:

    void Assign(const JObject_t& o)
    {
        if(data != o.data)
        {
            if(data)
                data -> Release();
            data = o.data;
            if(data)
                data->AddRef();
        }
    }

    void Assign(const jobject o)
    {
        if(data)
            data -> Release();
        if(o)
            data = new JData_t(o);
        else
            data = 0;
    }

public: 
    JObject_t():data(0){}
    JObject_t(const jobject o):data(0)
    {
        data = new JData_t(o);
    }

    JObject_t(const JObject_t& o):data(0)
    {
        Assign(o);
    }

    virtual ~JObject_t()
    {
        if(data)
            data->Release();
    }

    JObject_t& operator = (const JObject_t& o)
    {
        Assign(o);
        return *this;
    }

    operator const jobject() const
    {
        if(data)
            return data->operator const jobject();
        else
            return 0;
    }

    virtual bool isNullObject() const
    {
        return (data != 0)?(data->Obj==0):true;
    }
};

// Critical section object class
//

class JCriticalSection
{
public:
	void Lock() {EnterCriticalSection(&m_sec);}
	void Unlock() {LeaveCriticalSection(&m_sec);}
	JCriticalSection() {InitializeCriticalSection(&m_sec);}
	~JCriticalSection() {DeleteCriticalSection(&m_sec);}
	CRITICAL_SECTION m_sec;
};

