/******************************************************************
 *  All rights reserved  2005 Vitaly Shelest (Javain Ltd)
 *
 *  File name:              JStringHelper.h
 *
 *  Last modification:      20.03.2005
 *
 *  Description:            Java String Helper class
 *
 *  Authors:                Vitaly Shelest
 *
 *****************************************************************/

#pragma once

#pragma warning(disable:4251)
#pragma warning(disable:4786)

#include "jni.h"
#include <tchar.h>
#include <comdef.h>
#include "SmartString.h"

namespace jni_helpers
{
    // This class wraps the jstring type into a more convenient C++ class.
    
    class JStringHelper: public JObject_t
    {
    private:
        CSmartString str;

		jobject NewString(CSmartString p)
		{
			CSmartString str(p);
			return (jobject)JNIEnvHelper::getEnv()->NewString( reinterpret_cast<const jchar*>((BSTR)str), str.length() );
		}

    public:
        JStringHelper():str("")
        {
			Assign(0);
        };

        JStringHelper(const BSTR p):str("")
        {
			jobject tmpobject = (jobject)NewString(CSmartString(p));
			Assign(tmpobject);
			if(tmpobject)
				JNIEnvHelper::getEnv()->DeleteLocalRef(tmpobject);
        };

        JStringHelper(LPCTSTR p):str("")
        {
			jobject tmpobject = (jobject)NewString(p);
			Assign(tmpobject);
			if(tmpobject)
				JNIEnvHelper::getEnv()->DeleteLocalRef(tmpobject);
        };

        JStringHelper(LPTSTR p):str("")
        {
			jobject tmpobject = (jobject)NewString(p);
			Assign(tmpobject);
			if(tmpobject)
				JNIEnvHelper::getEnv()->DeleteLocalRef(tmpobject);
        };

        JStringHelper(const CSmartString p):str("")
        {
			jobject tmpobject = (jobject)NewString(p);
			Assign(tmpobject);
			if(tmpobject)
				JNIEnvHelper::getEnv()->DeleteLocalRef(tmpobject);
        };

        JStringHelper(jstring o):str("")
        {
			Assign((jobject)o);
        };

        JStringHelper(const JObject_t& o):str("")
        {
			Assign(o);
        };
        

        ~JStringHelper()
        {
        };

        JStringHelper& operator=(const jobject o)
        {
            str = "";
			Assign(o);
            return *this;
        }

        JStringHelper& operator=(const jstring o)
        {
            str = "";
			Assign((jobject)o);
            return *this;
        }

		operator const JObject_t&() const
		{
			return (JObject_t&)*this;
		}

        operator const jstring() const
        {
            return reinterpret_cast<const jstring> (JObject_t::operator const jobject());
        };
        
        operator LPCTSTR()
        {
			if(str.length() == 0 && JObject_t::operator const jobject() != 0)
			{
				jstring jstr = (jstring)JObject_t::operator const jobject();
				const jchar* jcstr = JNIEnvHelper::getEnv()->GetStringCritical(jstr, JNI_FALSE);
				BSTR bstr = ::SysAllocStringLen(jcstr, JNIEnvHelper::getEnv()->GetStringLength(jstr));
				str = CSmartString(bstr, false);
				JNIEnvHelper::getEnv()->ReleaseStringCritical(jstr, jcstr);
			}
            return (LPTSTR)str;
        };
        operator const CSmartString()
        {
			if(str.length() == 0 && JObject_t::operator const jobject() != 0)
			{
				jstring jstr = (jstring)JObject_t::operator const jobject();
				const jchar* jcstr = JNIEnvHelper::getEnv()->GetStringCritical(jstr, JNI_FALSE);
				BSTR bstr = ::SysAllocStringLen(jcstr, JNIEnvHelper::getEnv()->GetStringLength(jstr));
				str = CSmartString(bstr, false);
				JNIEnvHelper::getEnv()->ReleaseStringCritical(jstr, jcstr);
			}
            return str;
        };
    };
};

