/******************************************************************
 *  All rights reserved  2005 Vitaly Shelest (Javain Ltd)
 *
 *  File name:              JNIInterface.h
 *
 *  Last modification:      05.01.2006
 *
 *  Description:            Implements java Interface
 *
 *  Authors:                Vitaly Shelest
 *
 *****************************************************************/

#pragma once

#include "jni.h"

namespace jni_helpers {
#ifdef __JNIHDLL
	class __declspec(dllexport) JNIInterface: public JObject_t {
#elif __USEDLL
	class __declspec(dllimport) JNIInterface: public JObject_t {
#else
	class JNIInterface: public JObject_t {
#endif
    public:
        JNIInterface():clazz(0),Listener_ID(0){}
        virtual ~JNIInterface()
        {
            if(clazz)
            {
                JNIEnvHelper::UnregisterNatives(clazz);
                JNIEnvHelper::DeleteGlobalRef(clazz);
            }
        }
    protected:
        mutable jclass clazz;
        jmethodID Listener_ID;
        void init(CSmartString clazzName, const JNINativeMethod* methods, int mthcount, const jbyte* bytes, int bytecount);
    };
}

