/******************************************************************
 *  All rights reserved  2005 Vitaly Shelest (Javain Ltd)
 *
 *  File name:              JNIHelper.h
 *
 *  Last modification:      02.04.2005
 *
 *  Description:            CJNIEnv class
 *
 *  Authors:                Vitaly Shelest
 *
 *****************************************************************/

#pragma once

#include <jni.h>
//#pragma comment(lib, "jvm.lib")


class CJNIEnv {
    
private:
    JNIEnv* env;
    JavaVM *jvm;
    JavaVMInitArgs vm_args;
    JavaVMOption* options;
    _bstr_t newcp;
    _bstr_t bstrClassPath;
    _bstr_t bstrClPath;
    
public:
    CJNIEnv(JNIEnv* _env):env(0),jvm(0),bstrClassPath(""){
        env = _env;
        if(env)
            jvm = GetJavaVM();
    }

    CJNIEnv(JavaVM *_jvm):jvm(_jvm),bstrClassPath("") {
        AttachCurrentThread();
    }

    CJNIEnv(_bstr_t bstrPath = "", unsigned long ver = JNI_VERSION_1_2):env(0),jvm(0),bstrClassPath(""),bstrClPath(""){
        memset(&vm_args, 0, sizeof(vm_args));
        vm_args.version = ver;
        JNI_GetDefaultJavaVMInitArgs(&vm_args);
        if(bstrPath.length())
        {
            bstrClPath = bstrPath;
            options = new JavaVMOption[1];
            memset(options, 0, sizeof(JavaVMOption));
       		char* cp = getenv( "CLASSPATH" );
            bstrClPath = _bstr_t("-Djava.class.path=");
            bstrClPath += cp;
            bstrClPath += ";";
            bstrClPath += bstrPath + ";";
            options[0].optionString = bstrClPath;
            options[0].extraInfo = NULL;
            vm_args.nOptions = 1;
            vm_args.options = options;
        }
    }
    
    virtual ~CJNIEnv(){
        DetachCurrentThread();
        if(jvm)
            jvm -> DestroyJavaVM();
    }
    
    
    jint CreateJavaVM(){
        jint ret = JNI_CreateJavaVM(&jvm, (LPVOID*)&env, &vm_args);
        return ret;
    }
    
    jint GetCreatedJavaVMs(JavaVM** vmBuf, jsize bufLen, jsize* nVMs){
        return JNI_GetCreatedJavaVMs(vmBuf, bufLen, nVMs); 
    }

    
    jint GetJavaVM(){
        if(env)
            return env -> GetJavaVM(&jvm); 
        else
            return -1;
    }
  
    
    jint GetVersion(){
        if(env)
            return env -> GetVersion(); 
        else
            return -1;
    }
    
    jint AttachCurrentThread(void* thr_args = 0){
        if(jvm)
            return jvm -> AttachCurrentThread((void**)&env, thr_args);
        else
            return -1;
    }
    
    jint DetachCurrentThread(){
        if(jvm)
            return jvm -> DetachCurrentThread();
        else
            return -1;
    }
  
    
    _bstr_t GetStringChars(jstring string){
        _bstr_t res;
        jboolean isCopy;
        jchar* chars = (jchar*)env -> GetStringChars(string, &isCopy);
        jsize size = env -> GetStringLength(string);
        chars[size] = ((LPWSTR)_bstr_t("\0"))[0];
        res = chars;
        if(isCopy == JNI_TRUE)
            env -> ReleaseStringChars(string, chars);
        return res;
    }


    jstring SetStringChars(_bstr_t string){
        jstring res;
        return res;
    }

    operator JNIEnv*(){
        return env;
    }
    
    operator JavaVM*(){
        return jvm;
    }
};