/******************************************************************
 *  All rights reserved  2005 Vitaly Shelest (Javain Ltd)
 *
 *  File name:              ArrayIndexOutOfBoundsException.h
 *
 *  Last modification:      20.03.2005
 *
 *  Description:            ArrayIndexOutOfBounds Exception class
 *
 *  Authors:                Vitaly Shelest
 *
 *****************************************************************/

#pragma once
#include "BaseException.h"
#include "tchar.h"

namespace jni_helpers
{
    class ArrayIndexOutOfBoundsException : public BaseException
    {
    public:
        ArrayIndexOutOfBoundsException(jsize index, jsize size)
        {
            _TCHAR ind[10];
            msg = CSmartString("Array index out of bounds: index=") + _ltot(index, ind, 10) + CSmartString(", size=") +  _ltot(size, ind, 10);
        }
    };
};

